﻿using System;
using System.Collections.Generic;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class PatientRelatedDiagnoses : BasePage
{
    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/Patients.aspx",
        "/Patient.aspx",
        "/Referral.aspx",
        "/PatientWorkflows.aspx",
        "/PatientRelatedLabTests.aspx",
        "/PatientImaging.aspx"
    };

    private readonly EFRPatientManager _manager;

    public PatientRelatedDiagnoses()
    {
        _manager = new EFRPatientManager();

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            int patientId;
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
            {
                PATIENT patient = _manager.SelectByID(patientId);

                BreadCrumbLabel.Text = BreadCrumbLabel.Text + patient.FullName;

            }

            SetReferringPage();
        }
    }

    protected void ButtonBack_OnClick(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }
}
